/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.util.TimeSpan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class TimeSpiller {
    public static TimeSpiller interval(long start, long end) {
        return new IntervalSpiller(start, end, IntervalSpiller.Direction.FORWARD);
    }

    public static TimeSpiller reversedInterval(long start, long end) {
        return new IntervalSpiller(start, end, IntervalSpiller.Direction.BACKWARD);
    }

    public static TimeSpiller serial(TimeSpiller ... spillers) {
        return new SerialSpiller(spillers);
    }

    public static TimeSpiller parallel(TimeSpiller ... spillers) {
        return new ParallelSpiller(spillers);
    }

    public List<TimeSpan> spill(long time) {
        ArrayList<TimeSpan> spans = Lists.newArrayList();
        this.spill(spans, time);
        return TimeSpan.intervalUnion(spans);
    }

    protected abstract void spill(List<TimeSpan> var1, long var2);

    protected abstract long getCapacity();

    private static class IntervalSpiller
    extends TimeSpiller {
        private final TimeSpan interval;
        private final boolean backward;

        private IntervalSpiller(long start, long end, Direction direction) {
            Preconditions.checkArgument(start <= end);
            this.interval = TimeSpan.fromStartEnd(start, end);
            this.backward = direction == Direction.BACKWARD;
        }

        @Override
        protected void spill(List<TimeSpan> result, long time) {
            Preconditions.checkArgument(time >= 0L);
            Preconditions.checkArgument(time <= this.interval.getLength());
            if (this.backward) {
                result.add(TimeSpan.fromStartEnd(this.interval.getEnd() - time, this.interval.getEnd()));
            } else {
                result.add(TimeSpan.fromStartEnd(this.interval.getStart(), this.interval.getStart() + time));
            }
        }

        @Override
        protected long getCapacity() {
            return this.interval.getLength();
        }

        static enum Direction {
            FORWARD,
            BACKWARD;

        }
    }

    public static class SerialSpiller
    extends GroupSpiller {
        private SerialSpiller(TimeSpiller ... spillers) {
            super(spillers);
        }

        @Override
        protected void spill(List<TimeSpan> result, long time) {
            Preconditions.checkArgument(time >= 0L);
            Preconditions.checkArgument(time <= this.getCapacity());
            for (TimeSpiller spiller : this.spillers) {
                if (time <= 0L) break;
                long t = Math.min(spiller.getCapacity(), time);
                time -= t;
                spiller.spill(result, t);
            }
        }
    }

    private static class ParallelSpiller
    extends GroupSpiller {
        private final double[] ratios;

        private ParallelSpiller(TimeSpiller ... spillers) {
            super(spillers);
            this.ratios = new double[spillers.length];
            for (int i = 0; i < spillers.length; ++i) {
                this.ratios[i] = (double)spillers[i].getCapacity() / (double)this.getCapacity();
            }
        }

        @Override
        protected void spill(List<TimeSpan> result, long time) {
            int i;
            Preconditions.checkArgument(time >= 0L);
            Preconditions.checkArgument(time <= this.getCapacity());
            int l = this.ratios.length;
            long[] times = new long[l];
            long rem = time;
            for (i = 0; i < l; ++i) {
                times[i] = (long)Math.floor((double)time * this.ratios[i]);
                times[i] = Math.min(times[i], ((TimeSpiller)this.spillers.get(i)).getCapacity());
                rem -= times[i];
            }
            if (rem > 0L) {
                i = 0;
                while (i < l || rem > 0L) {
                    long d = Math.min(((TimeSpiller)this.spillers.get(i)).getCapacity() - times[i], rem);
                    int n = i++;
                    times[n] = times[n] + d;
                    rem -= d;
                }
            }
            for (i = 0; i < l; ++i) {
                if (times[i] <= 0L) continue;
                ((TimeSpiller)this.spillers.get(i)).spill(result, times[i]);
            }
        }
    }

    private static abstract class GroupSpiller
    extends TimeSpiller {
        protected final List<TimeSpiller> spillers;
        private final long max;

        protected GroupSpiller(TimeSpiller ... spillers) {
            this.spillers = Arrays.asList(spillers);
            Preconditions.checkArgument(!this.spillers.isEmpty());
            long max = 0L;
            for (TimeSpiller spiller : spillers) {
                max += spiller.getCapacity();
            }
            this.max = max;
        }

        @Override
        protected long getCapacity() {
            return this.max;
        }
    }
}

